export default function generateMonolithicClassName(style, prefix) {
  if (style.className) {
    var name = prefix + style.className;
    delete style.className;
    return name;
  }

  var stringified = JSON.stringify(style);
  var val = 5381;
  var i = stringified.length;

  while (i) {
    val = val * 33 ^ stringified.charCodeAt(--i);
  }

  var hashedName = (val >>> 0).toString(36);
  if (prefix) {
    return prefix + hashedName;
  }
  return "f" + hashedName;
}