'use strict';

exports.__esModule = true;
exports.objStyle = exports.hydrate = exports.keyframes = exports.fontFace = exports.injectGlobal = exports.css = exports.flush = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _index = require('../index');

Object.defineProperty(exports, 'flush', {
  enumerable: true,
  get: function get() {
    return _index.flush;
  }
});
Object.defineProperty(exports, 'css', {
  enumerable: true,
  get: function get() {
    return _index.css;
  }
});
Object.defineProperty(exports, 'injectGlobal', {
  enumerable: true,
  get: function get() {
    return _index.injectGlobal;
  }
});
Object.defineProperty(exports, 'fontFace', {
  enumerable: true,
  get: function get() {
    return _index.fontFace;
  }
});
Object.defineProperty(exports, 'keyframes', {
  enumerable: true,
  get: function get() {
    return _index.keyframes;
  }
});
Object.defineProperty(exports, 'hydrate', {
  enumerable: true,
  get: function get() {
    return _index.hydrate;
  }
});
Object.defineProperty(exports, 'objStyle', {
  enumerable: true,
  get: function get() {
    return _index.objStyle;
  }
});


var styled = function styled(tag, cls) {
  var vars = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
  var content = arguments[3];

  return {
    cls: '.' + cls,
    functional: true,
    render: function render(h, context) {
      var getValue = function getValue(v) {
        return v && typeof v === 'function' ? v(context.props) : v.cls || v;
      };
      var className = (0, _index.css)(cls.map(getValue), vars.map(getValue), content);
      return h(tag, _extends({}, context.data, {
        class: [context.data.class, className]
      }), context.children);
    }
  };
};

exports.default = styled;