'use strict';

exports.__esModule = true;
exports.objStyle = exports.hydrate = exports.keyframes = exports.fontFace = exports.injectGlobal = exports.css = exports.flush = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _index = require('../index');

Object.defineProperty(exports, 'flush', {
  enumerable: true,
  get: function get() {
    return _index.flush;
  }
});
Object.defineProperty(exports, 'css', {
  enumerable: true,
  get: function get() {
    return _index.css;
  }
});
Object.defineProperty(exports, 'injectGlobal', {
  enumerable: true,
  get: function get() {
    return _index.injectGlobal;
  }
});
Object.defineProperty(exports, 'fontFace', {
  enumerable: true,
  get: function get() {
    return _index.fontFace;
  }
});
Object.defineProperty(exports, 'keyframes', {
  enumerable: true,
  get: function get() {
    return _index.keyframes;
  }
});
Object.defineProperty(exports, 'hydrate', {
  enumerable: true,
  get: function get() {
    return _index.hydrate;
  }
});
Object.defineProperty(exports, 'objStyle', {
  enumerable: true,
  get: function get() {
    return _index.objStyle;
  }
});

exports.default = function (tag, cls) {
  var _Styled$contextTypes;

  var vars = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
  var content = arguments[3];

  if (!tag) {
    throw new Error('You are trying to create a styled element with an undefined component.\nYou may have forgotten to import it.');
  }

  var Styled = function (_Component) {
    _inherits(Styled, _Component);

    function Styled() {
      var _temp, _this, _ret;

      _classCallCheck(this, Styled);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return _ret = (_temp = (_this = _possibleConstructorReturn(this, _Component.call.apply(_Component, [this].concat(args))), _this), _this.state = {
        theme: {}
      }, _this.setTheme = function (theme) {
        return _this.setState({ theme: theme });
      }, _temp), _possibleConstructorReturn(_this, _ret);
    }

    Styled.prototype.componentWillMount = function componentWillMount() {
      if (this.context[_constants.CHANNEL]) {
        this.setState({ theme: this.context[_constants.CHANNEL].getState() });
      }
    };

    Styled.prototype.componentDidMount = function componentDidMount() {
      if (this.context[_constants.CHANNEL]) {
        this.unsubscribe = this.context[_constants.CHANNEL].subscribe(this.setTheme);
      }
    };

    Styled.prototype.componentWillUnmount = function componentWillUnmount() {
      if (typeof this.unsubscribe === 'function') {
        this.unsubscribe();
      }
    };

    Styled.prototype.render = function render() {
      var props = this.props,
          state = this.state;

      var mergedProps = _extends({}, props, {
        theme: state.theme
      });

      var getValue = function getValue(v) {
        return v && typeof v === 'function' ? v.cls || v(mergedProps) : v;
      };

      var className = (0, _index.css)((0, _utils.map)(cls, getValue), (0, _utils.map)(vars, getValue), content);

      return (0, _react.createElement)(tag, (0, _utils.omit)(Object.assign({}, mergedProps, {
        ref: mergedProps.innerRef,
        className: mergedProps.className ? className + ' ' + mergedProps.className : className
      }), ['innerRef', 'theme']));
    };

    return Styled;
  }(_react.Component);

  Styled.contextTypes = (_Styled$contextTypes = {}, _Styled$contextTypes[_constants.CHANNEL] = _propTypes2.default.object, _Styled$contextTypes);

  var name = typeof cls[0] === 'string' ? cls[0].split('-')[1] : '';
  var componentTag = tag.displayName || tag.name || 'Component';
  Styled.displayName = 'styled(' + componentTag + name + ')';
  Styled.cls = '.' + cls;
  return Styled;
};

var _react = require('react');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _utils = require('../utils');

var _constants = require('./constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }