import { StatusObject } from './call-stream';
import { ServiceConfig } from './service-config';
import { ChannelOptions } from './channel-options';
import { ClusterLoadAssignment__Output } from './generated/envoy/api/v2/ClusterLoadAssignment';
export interface Watcher<UpdateType> {
    onValidUpdate(update: UpdateType): void;
    onTransientError(error: StatusObject): void;
    onResourceDoesNotExist(): void;
}
export declare class XdsClient {
    private targetName;
    private serviceConfigWatcher;
    private node;
    private client;
    private adsCall;
    private hasShutdown;
    private endpointWatchers;
    private lastEdsVersionInfo;
    private lastEdsNonce;
    private latestEdsResponses;
    constructor(targetName: string, serviceConfigWatcher: Watcher<ServiceConfig>, channelOptions: ChannelOptions);
    /**
     * Start the ADS stream if the client exists and there is not already an
     * existing stream, and there
     */
    private maybeStartAdsStream;
    private nackUnknown;
    /**
     * Acknowledge an EDS update. This should be called after the local nonce and
     * version info are updated so that it sends the post-update values.
     */
    private ackEds;
    /**
     * Reject an EDS update. This should be called without updating the local
     * nonce and version info.
     */
    private nackEds;
    /**
     * Validate the ClusterLoadAssignment object by these rules:
     * https://github.com/grpc/proposal/blob/master/A27-xds-global-load-balancing.md#clusterloadassignment-proto
     * @param message
     */
    private validateEdsResponse;
    private handleEdsResponse;
    private updateEdsNames;
    private reportStreamError;
    addEndpointWatcher(edsServiceName: string, watcher: Watcher<ClusterLoadAssignment__Output>): void;
    removeEndpointWatcher(edsServiceName: string, watcher: Watcher<ClusterLoadAssignment__Output>): void;
    shutdown(): void;
}
