/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import * as firestore from '../../../lite-types';
import { FirebaseApp, _FirebaseService } from '@firebase/app-types-exp';
import { Provider } from '@firebase/component';
import { DatabaseId, DatabaseInfo } from '../../../src/core/database_info';
import { FirebaseAuthInternalName } from '@firebase/auth-interop-types';
import { CredentialsProvider } from '../../../src/api/credentials';
import { Datastore } from '../../../src/remote/datastore';
export declare const DEFAULT_HOST = "firestore.googleapis.com";
export declare const DEFAULT_SSL = true;
export declare const DEFAULT_FORCE_LONG_POLLING = false;
/**
 * The root reference to the Firestore Lite database.
 */
export declare class Firestore implements firestore.FirebaseFirestore, _FirebaseService {
    readonly _databaseId: DatabaseId;
    private readonly _firebaseApp;
    protected readonly _credentials: CredentialsProvider;
    protected _settings?: firestore.Settings;
    private _datastorePromise?;
    constructor(app: FirebaseApp, authProvider: Provider<FirebaseAuthInternalName>);
    get app(): FirebaseApp;
    _configureClient(settings: firestore.Settings): void;
    _getSettings(): firestore.Settings;
    _getDatastore(): Promise<Datastore>;
    protected _makeDatabaseInfo(host?: string, ssl?: boolean): DatabaseInfo;
    private static databaseIdFromApp;
    delete(): Promise<void>;
    INTERNAL: {
        delete: () => Promise<void>;
    };
}
export declare function initializeFirestore(app: FirebaseApp, settings: firestore.Settings): Firestore;
export declare function getFirestore(app: FirebaseApp): Firestore;
export declare function terminate(firestore: firestore.FirebaseFirestore): Promise<void>;
