import {
  ERROR_ACCOUNT_CONFIRM_PASSWORD,
  ERROR_AUTH_EMAIL_IS_INVALID,
  ERROR_AUTH_EMAIL_IS_USED,
  ERROR_AUTH_INV_DISPLAY_NAME,
  ERROR_AUTH_USER_IS_DISABLED,
  ERROR_AUTH_USER_NOT_FOUND,
  ERROR_AUTH_WEEK_PASSWORD,
  ERROR_AUTH_WRONG_PASSWORD,
} from '../constants';

export const ERROR_CODE_MESSAGES = {
  [ERROR_AUTH_EMAIL_IS_USED]: [
    'email',
    'This email already in use. Try another one or try to sign in',
  ],
  [ERROR_AUTH_EMAIL_IS_INVALID]: ['email', 'Algo errado com este e -mail'],
  [ERROR_AUTH_USER_IS_DISABLED]: ['email', 'Esta conta foi desativada.O que você fez?'],
  [ERROR_AUTH_USER_NOT_FOUND]: ['senha', 'A senha ou e -mail está incorreto'],
  [ERROR_AUTH_WRONG_PASSWORD]: ['senha', 'Tele senha ou e -mail está incorreto'],
  [ERROR_AUTH_WEEK_PASSWORD]: [
    'senha',
    'Esta senha é curta. Deve ser pelo menos 6 \ caracteres',
  ],
  [ERROR_AUTH_INV_DISPLAY_NAME]: ['nome', 'Vamos ser amigos!Qual o seu nome?'],
  [ERROR_ACCOUNT_CONFIRM_PASSWORD]: ['Repassword', 'As senhas devem corresponder'],
};

export const ERROR_CODE_RECOVERY_MESSAGES = {
  [ERROR_AUTH_EMAIL_IS_INVALID]: ['Email ',' algo errado com este e -mail'],
  [ERROR_AUTH_USER_IS_DISABLED]: ['E -mail ',' Esta conta foi desativada.O que você fez?'],
  [ERROR_AUTH_USER_NOT_FOUND]: ['Email ',' não encontramos ninguém com este e -mail nos registros'],
};

/**
 * Converts API error to form error object
 *
 * @param error {string}
 * @param [context] {string}
 * @returns {object|null}
 */
export default function errorCodeToState(error, context) {
  let messages;
  if (context === 'recovery') {
    messages = ERROR_CODE_RECOVERY_MESSAGES;
  } else {
    messages = ERROR_CODE_MESSAGES;
  }
  if (error in messages) {
    const [fieldName, message] = ERROR_CODE_MESSAGES[error];
    return { [fieldName]: message };
  }
  return undefined;
}
