import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { Link, Redirect } from 'react-router-dom';
import Layout from '../components/Layout/Layout';
import Header from '../components/Header/Header';
import AuthHeaderText from '../components/AuthHeaderText/AuthHeaderText';
import PageTitle from '../components/PageTitle/PageTitle';
import FormRegister from '../components/FormRegister/FormRegister';
import { resetAuthForms } from '../actions/auth';

class Register extends Component {
  static propTypes = {
    dispatch: PropTypes.func.isRequired,
    isAuthenticated: PropTypes.bool.isRequired,
    isSubmitting: PropTypes.bool,
    errors: PropTypes.shape({
      name: PropTypes.string,
      email: PropTypes.string,
      password: PropTypes.string,
    }),
    location: PropTypes.shape({
      state: PropTypes.any,
    }).isRequired,
  };

  static defaultProps = {
    errors: undefined,
    isSubmitting: false,
  };

  componentDidMount() {
    const { dispatch } = this.props;
    dispatch(resetAuthForms());
  }

  render() {
    const { dispatch, location, errors, isSubmitting, isAuthenticated } = this.props;
    const historyState = location.state;
    let to;

    if (isAuthenticated) {
      to = {
        pathname: (historyState && historyState.redirectTo) || '/',
        state: {
          registered: true,
        },
      };
      return <Redirect to={to} />;
    }

    const signInLink = {
      pathname: '/sign-in',
      state: historyState,
    };

    return (
      <Layout>
        <Layout.Header>
          <Header
            btnBack
            right={
              <AuthHeaderText>
                <span>Já tem uma conta?</span> <Link to={signInLink}>Entrar</Link>
              </AuthHeaderText>
            }
          />
        </Layout.Header>
        <Layout.Container>
          <Layout.Inner>
            <PageTitle
              title="Crie sua conta"
              subtitle="Você está a um passo do seu primeiro canvas."
            />
            <FormRegister dispatch={dispatch} errors={errors} isSubmitting={isSubmitting} />
          </Layout.Inner>
        </Layout.Container>
      </Layout>
    );
  }
}

const mapStateToProps = state => {
  const { auth } = state;
  const { isAuthenticated, errors, isSubmitting } = auth;

  return {
    isAuthenticated,
    errors,
    isSubmitting,
  };
};

export default connect(mapStateToProps)(Register);
