import React from 'react';
import './PageNotFound.scss';
import Grid from '../Grid/Grid';
import Button from '../Button/Button';
import Icon from '../Icon/Icon';

const PageNotFound = () => (
  <Grid className="page-not-found">
    <Grid.Row valign="center">
      <Grid.Col md={5} mdOffset={1}>
        <div className="page-not-found__content">
          <h1>Perdido no espaço</h1>
          <p>Há um erro no endereço da web da página, ou{'\u00a0'}A página é excluída.</p>
          <p>
            <Button href="/" size="x-small">
              <Icon name="arrow-back" /> De volta para o início
            </Button>
          </p>
        </div>
      </Grid.Col>
      <Grid.Col md={6}>
        <img src={`${process.env.PUBLIC_URL}/img/page-not-found-4.png`} alt="404" />
        <p className="page-not-found__caption">
          Ilustração por{' '}
          <a href="https://icons8.com" target="_blank" rel="noreferrer noopener">
            Ochpics
          </a>
        </p>
      </Grid.Col>
    </Grid.Row>
  </Grid>
);

export default PageNotFound;
