import React from 'react';
import { Picture } from 'react-responsive-picture';
import Tabs from '../Tabs/Tabs';
import Grid from '../Grid/Grid';

const HowToCanvas = () => (
  <Tabs align="top">
    <Tabs.Pane key="business" icon="segment" tab="Modelo de negócio canvas">
      <Grid>
        <Grid.Row valign="center">
          <Grid.Col md={6}>
            <p>
              <Picture alt="Business Model Canvas" src={require('./img/modelocanvas.svg')} />
            </p>
          </Grid.Col>
          <Grid.Col md={6}>
            <h3>Modelo de negócio canvas</h3>
            <p className="text_size_bigger">
              O canvas de modelo de negócios é uma ótima maneira de mapear uma idéia, permitindo que seja
              entendido, testado e melhorado.
            </p>
            <p className="text_size_bigger">
              Não há regras estritas sobre como preencher o canvas. Sinta-se à vontade para fazer isso por conta própria
              caminho. No entanto, existem algumas recomendações gerais que podem ajudá-lo a melhorar o
              resultado.
            </p>
          </Grid.Col>
        </Grid.Row>
        <Grid.Row>
          <Grid.Col xl={6} xlOffset={3} md={8} mdOffset={2}>
            <h3>Como fazer?</h3>

            <h4>Proposta de Valor</h4>
            <p>
            Aqui, você precisa indicar de forma simples qual é o valor que você está oferecendo aos seus clientes.
            Ela está ligada ao que você irá oferecer para o mercado, desde o produto e suas qualidades, até de que forma você vai mudar a vida de quem confia na sua empresa.
            Para isso, algumas perguntas precisam ser feitas:
            </p>

            <p>Por que meus clientes vão comprar/usar meu produto ou serviço?</p>
            <p>Qual problema o meu produto ou serviço está resolvendo?</p>
            <p>Qual valor entregamos aos clientes?</p>
            <p>Quais necessidades ou desejos dos clientes o meu negócio pode suprir?</p>



            <h4>Segmento de Clientes</h4>

            <p>
            São todas as informações necessárias para conhecer muito bem o público que desejamos impactar.
            Focaremos em descobrir para quem o seu negócio gera valor, qual o público-alvo que irá consumir seus produtos ou serviços.
            Tente ser bem específico, defina, por exemplo, quais são as preferências, os comportamentos e a localização do seu segmento de clientes.
            Ainda, responda perguntas como:
            </p>

            <p>Meu público é composto de homens ou mulheres? </p>
            <p>Qual é a idade deles? </p>
            <p>Qual é o perfil? </p>
            <p>São empresas? </p>
            <p>De que tamanho? </p>
            <p>De qual segmento?</p>


            <h4>Canais</h4>
            <p>
            Canais que você utilizará para manter contato com os seus clientes e potenciais leads, sendo assim, fica claro que esse item está dentro do nível cliente. Primeiramente, vale destacar que existem diferentes tipos de canais. Os canais de comunicação são focados em melhorar o relacionamento com os públicos e gerar autoridade para a sua marca.
            Já os canais de distribuição são, por exemplo, os Correios, uma transportadora ou um motoboy. Por fim, os canais de venda podem ser o telefone ou a internet, entre outros.
            Esse aspecto é bastante relevante porque abrange como os seus clientes vão conhecer, comprar e receber o seu produto ou serviço. Hoje, existem inúmeros canais de comunicação e diferentes estratégias de marketing digital que podem ser usadas em uma empresa.
            Para te ajudar no preenchimento, você pode pensar em perguntas, como:
            </p>
            <p>Por meio de quais canais o segmento de clientes quer ser contatado? </p>
            <p>Quais canais funcionam melhor? </p>
            <p>Quais são os mais assertivos? </p>
            <p>Quais têm o melhor custo?</p>
            <p>Ao pensar em canais, lembre-se de considerar as características dos seus clientes. Você pode conciliar vários canais simultaneamente, e deve considerar os tipos de canais mais utilizados no seu segmento.</p>


            <h4>Relacionamento</h4>
            <p>
            Quem empreende sabe que o relacionamento com os clientes é um aspecto fundamental do negócio. Tal ponto envolve qual é a sua linguagem, como a marca se posiciona e de que maneira você se conecta com o seu público.
            Nesse sentido, as relações podem ser pessoais, isso é, com interação humana, como ocorre em uma loja física, por exemplo. Elas também podem ser “self-service”, quando ocorre o autoatendimento. Além disso, é possível ter relações automatizadas. Essa escolha tem muito a ver com o seu perfil de clientes, por isso é importante conhecê-lo de maneira aprofundada.
            Também é indicado que você defina ações de relacionamento com clientes pensando em 3 objetivos principais:
            </p>

            <p>Atrair: ações para atrair clientes;</p>
            <p>Manter: ações para manter tais clientes ativos;</p>
            <p>Aumentar: ações para gerar escala e atrair ainda mais clientes, ou para vender mais produtos e serviços para os mesmos clientes (técnica de vendas conhecida como upsell).
            Um bom relacionamento com os clientes demanda utilizar os canais certos e fazer um bom uso deles, de forma que a sua eficiência consiga cativar, satisfazer clientes e aumentar o faturamento.
            </p>


            <h4>Fontes de receita</h4>
            <p>
            Esse item está no nível finanças, obviamente, porque elas traduzem como a sua empresa vai gerar lucro. Será vendendo um produto ou serviço? Por meio de um aluguel? Ou será com taxa de corretagem? E quem sabe até pelo uso de anúncios?
            Esse é um item que muitas vezes os empreendedores ainda não têm claro. Portanto, muitos o ajustam no meio do caminho e isso não é necessariamente um problema. Nessa etapa, você terá que avaliar quanto os seus clientes estão dispostos a pagar e como eles pagariam. Dependendo do seu modelo de negócio, pode haver mais de uma fonte de receita.
            Um problema desse item é que ele parece fácil na teoria, mas a prática costuma se apresentar como um desafio. À medida que o negócio entra em operação, pode haver dificuldades em vender ou acertar valores que sejam competitivos e tragam lucro.
            </p>


            <h4>Atividades-chave</h4>
            <p>
            Quais são as atividades indispensáveis para a sua empresa funcionar. Por exemplo, em um restaurante, cozinhar, lavar as louças, atender os clientes e limpar o local são atividades-chave. Elas são sempre executadas para poder viabilizar a proposta de valor que você definiu.
            Com isso em mente, fica claro que as atividades-chave fazem parte da base da operação, ou seja, da infraestrutura, que é o nível desse item no Business Model Canvas.
            No caso de serviços, você pode pensar quais são as atividades essenciais para resolver o problema do cliente. Em uma indústria, é necessário listar todas as etapas da produção. Em qualquer empresa, as atividades principais são necessárias para chegar ao mercado, manter o relacionamento com os clientes e expandir lucros.
            </p>


            <h4>Recursos-chave</h4>
            <p>
            Os recursos-chave seguem uma lógica semelhante ao item das atividades-chave, o que faz desse sétimo item componente importante do nível de infraestrutura do Business Model Canvas, porque ambos constroem a base da operação, o que é necessário para o negócio funcionar. Então, é preciso pensar em quais são os recursos necessários para realizar as atividades primordiais.
            Pense em recursos humanos, intelectuais, financeiros e físicos que não podem faltar para a sua empresa funcionar corretamente. Vale destacar que os recursos podem ser comprados, alugados ou até mesmo obtidos por meio de parcerias com outras empresas sem ônus financeiro.
            Nessa etapa, você pode se guiar com perguntas como:

            </p>
            <p>Quais são os recursos que preciso para atender a proposta de valor?</p>
            <p>Qual recurso é indispensável para a existência da minha empresa?</p>
            <p>Quais as formas menos onerosas de se obter estes recursos?</p>

            <h4>Parceiros-chave</h4>
            <p>
            Empreendedores de sucesso têm um networking bem desenvolvido. Por isso, o oitavo bloco do business model canvas são os parceiros-chave, que nada mais é do que as pessoas para ajudar o negócio a operar no mercado, colocando as parcerias principais no nível de infraestrutura. Aqui, é preciso refletir sobre a rede de fornecedores e parceiros que vão ajudar sua empresa a entregar o valor que ela promete.
            Parceiros podem ajudar a melhorar a desempenho do negócio e otimizar processos. Mas, nessa etapa, liste apenas os parceiros mais importantes. Ou seja, aqueles que vão realizar atividades-chave. Muitas vezes, eles são empresas terceirizadas, por exemplo. Até mesmo porque, como você bem sabe, toda parceria implica na oferta de uma contrapartida
            </p>



            <h4>Estrutura de custos</h4>
            <p>
            Nesse bloco, descreva quais são as despesas e investimentos que você terá com sua empresa, sejam eles fixos ou variáveis, ou seja, como será feita a organização das finanças, o nível da estrutura de custos no Business Model Canvas.
            Lembre-se de que quase todos os outros itens do business model canvas geram custos, até mesmo as fontes de receita. Afinal, elas podem ter cobranças, como impostos ou taxas de cartão de crédito, por exemplo.
            Mas, não tem problema se você não souber os valores exatos na primeira vez em que preencher o canvas. O mais importante é já pensar em todos os itens de custos que a sua operação gerará.
            </p>

            <h3>A ideia tá ái, bora fazer!</h3>

          </Grid.Col>
        </Grid.Row>
      </Grid>
    </Tabs.Pane>
    <Tabs.Pane key="value" icon="gift" tab="Proposta de valor">
      <Grid>
        <Grid.Row valign="center">
          <Grid.Col md={6}>
            <p>
              <Picture alt="Business Model Canvas" src={require('./img/propostadevalor.svg')} />
            </p>
          </Grid.Col>
          <Grid.Col md={6}>
            <h3>Proposta de valor Canvas</h3>
            <p className="text_size_bigger">
            Ela é uma ferramenta que surgiu para auxiliar na criação e no posicionamento de produtos e/ou serviços em torno do que o cliente deseja e precisa. Ou seja, é uma ferramenta de organização que ajuda empreendedores a criarem soluções, considerando a demanda de seus clientes. É complementar ao Business Model Canvas, que apesar de ter vários benefícios, não é tão completo. A Proposta de Valor Canvas é um aprofundamento de dois blocos do Bussines Model Canvas, segmentos de clientes e a proposta de valor. Assim, ela pode ser usado quando é necessário otimizar um produto ou serviço existente, ou quando uma nova oferta é criada do zero.

            </p>
          </Grid.Col>
        </Grid.Row>
        <Grid.Row>
          <Grid.Col xl={6} xlOffset={3} md={8} mdOffset={2}>
            <h3>Cliente</h3>
            <p>
            No núcleo da área do cliente, está a programação neuro-linguística e a psicologia sobre motivação para a tomada de decisão.

            </p>
            <h4>Segmento de clientes</h4>
            <p>
            São todas as informações necessárias para conhecer muito bem o público que desejamos impactar.
            Focaremos em descobrir para quem o seu negócio gera valor, qual o público-alvo que irá consumir seus produtos ou serviços.
            Tente ser bem específico, defina, por exemplo, quais são as preferências, os comportamentos e a localização do seu segmento de clientes.
            Ainda, responda perguntas como:
            </p>

            <p>Meu público é composto de homens ou mulheres?</p>
            <p>Qual é a idade deles?</p>
            <p>Qual é o perfil?</p>
            <p>São empresas?</p>
            <p>De que tamanho?</p>
            <p>De qual segmento?</p>


            <h4>Ganhos</h4>
            <p>
            podem ser divididos em quatro principais grupos: a) necessários — benefícios essenciais em relação a sua oferta; b) esperados — pode(m) existir ou não, mas não chegam a comprometer a conclusão do objetivo do cliente; c) desejados — aquilo que o cliente tem acima das expectativas em relação ao seu produto ou serviço; e d) inesperados —  aquilo que faz com que os clientes se surpreendam e se encantem.
            </p>


            <p>Quais tarefas seus potenciais clientes precisam concluir?</p>
            <p> Quais objetivos você precisa ajudá-los a alcançar?</p>
            <p> Em qual contexto a(s) tarefa(s) ocorre(m)?</p>

            <h4>Tarefas do cliente</h4>
            <p>
            Podem ser entendidas basicamente como as necessidades que os clientes querem satisfazer e/ou problemas que desejam solucionar. Essas tarefas estão geralmente divididas em três grandes grupos:
            </p>

            <p>a) Tarefas funcionais — atividades práticas relacionadas a um objetivo específico, como, por exemplo, comprar um medicamento, pesquisar algum produto, ler;</p>
            <p> b) Tarefas sociais — relacionadas a uma nova condição desejada, por exemplo, poder, status, etc.; e</p>
            <p> c) Tarefas pessoais/emocionais — que trazem benefícios e melhoria ao estado emocional atual, como, melhorar a autoestima, o poder de concentração etc.</p>
            <p>Quais tarefas seus potenciais clientes precisam concluir?</p>
            <p>Quais objetivos você precisa ajudá-los a alcançar?</p>
            <p>Em qual contexto a(s) tarefa(s) ocorre(m)?</p>



            <h4> Dores</h4>
            <p>
            Como o  próprio nome sugere, é tudo aquilo que torna a vida do seu público-alvo mais difícil, complexa — em menor ou maior grau de intensidade. As dores (assim como no caso das dores físicas) são aquelas que realmente incomodam, chegam a irritar. Pensar em dores reais fará com que você se torne uma alternativa para solucioná-las. Liste as emoções negativas, custos e situações indesejáveis e os riscos.
            </p>

            <p>Quais são as perdas significativas que seu público-alvo tem ao conviver com essas dores? </p>
            <p>As perdas podem estar associadas à perdas financeiras, de tempo, frustrações, insatisfações, etc.</p>
            <p>Quais barreiras ou dificuldades fazem com que eles não consigam solucionar essas dores atualmente? </p>




            <br />

            <h4> Proposta de valor </h4>
            <p>
            Aqui, você precisa indicar de forma simples qual é o valor que você está oferecendo aos seus clientes. Ela está ligada ao que você irá oferecer para o mercado, desde o produto e suas qualidades, até de que forma você vai mudar a vida de quem confia na sua empresa. Para isso, algumas perguntas precisam ser feitas:
            </p>
            <p>Por que meus clientes vão comprar/usar meu produto ou serviço?</p>
            <p>Qual problema o meu produto ou serviço está resolvendo?</p>
            <p>Qual valor entregamos aos clientes?</p>
            <p>Quais necessidades ou desejos dos clientes o meu negócio pode suprir?</p>


            <h4>Aliviadores das dores</h4>
            <p>
            São os “remediadores” (também chamados de analgésicos). Estão associados ao COMO a sua empresa irá solucionar os problemas identificados.
            </p>

            <p>O que fará com que as dores dos seus clientes sejam reduzidas ou eliminadas? Lembre-se de olhar o quadrante dores.</p>

            <h4>Criadores de ganhos</h4>
            <p>
            Descrevem claramente o conjunto de benefícios da sua oferta.
            </p>
            <p>O que fará com que seus clientes ganhem algum benefício? Lembre-se de olhar o quadrante ganhos.</p>

            <h4>Produtos e serviços</h4>
            <p>
            Aquilo que é tangível e/ou intangível e que efetivamente você irá entregar de valor para seus clientes.
            </p>

            <p>Como tornar a sua oferta mais relevante em relação à concorrência? </p>


            <h4>Produtos substitutos </h4>
            <p>
            Além dos concorrentes diretos e indiretos, precisamos avaliar também, quais produtos/serviços poderiam substituir o que oferecemos hoje.
            </p>
            <br />

            <h3>A ideia tá ái, bora fazer!</h3>
          </Grid.Col>
        </Grid.Row>
      </Grid>
    </Tabs.Pane>
    <Tabs.Pane key="lean" icon="lean" tab="Lean Canvas">
      <Grid>
        <Grid.Row valign="center">
          <Grid.Col md={6}>
            <p>
              <Picture alt="Business Model Canvas" src={require('./img/lean.svg')} />
            </p>
          </Grid.Col>
          <Grid.Col md={6}>
            <h3>Lean canvas </h3>
            <p className = "text_size_bigger">
            O lean canvas é uma versão do canvas de modelo de negócios adotada por Ash Maurya para startup lean. Tem seu foco nos itens mais importantes com a qual você deve se preocupar quando você lança um novo negócio: quem são seus clientes, quais problemas você está tentando resolver, quais são os seus KPIs para entender o sucesso, como você se destaca de seus concorrentes, etc.
            </p>

            <p></p>
            <p></p>
            <p></p>
            <p></p>
            <p></p>
            <p></p>
          </Grid.Col>
        </Grid.Row>
        <Grid.Row>
          <Grid.Col xl={6} xlOffset={3} md={8} mdOffset={2}>

          <h4>Como preencher o lean canvas?</h4>
            <p>Semelhante ao canvas de modelo de negócios, você pode dividir o Lean canvas em duas grandes áreas:</p>
           <p> A metade direita representa seu mercado</p>
           <p> A metade esquerda representa seu produto</p>
           <p> Recomendamos iniciar qualquer negócio identificando seus problemas e descrevendo o seu cliente para depois desenvolver a parte do produto.</p>

            <br />

            <h4> Problemas </h4>
            <p>
            Cada segmento de clientes com quem você está pensando em trabalhar terá um conjunto de problemas que eles precisam resolver. Nesta caixa, tente listar pelo menos três problemas de alta prioridade que seu cliente tem. Sem um problema a ser resolvido, você não tem nada a oferecer.

            </p>
            <h4>Alternativas existentes </h4>
            <p>Descreva como esses problemas são solucionados hoje. Busque por todas as alternativas existentes, por exemplo, para o serviço de táxi, poderia ser uma caminhada ou uma bicicleta.</p>

            <h4> Segmentos de cliente</h4>
            <p>
            Sem um cliente, não há problema para resolver e vice-versa. Descreva os seguimentos de clientes com maior nível de detalhes possível. Evite descrição geral, como "mercado de massa".
            </p>
            <h4>Primeiros clientes</h4>
            <p>  Quem são aquelas pessoas que serão as primeiras da fila a experimentar Produto/Serviço? Geralmente, são clientes com maior dor dos problemas que você é tentando resolver.</p>

            <h4>Proposta de valor exclusiva</h4>
            <p>
            A proposta de valor exclusiva deve ser uma única mensagem clara e atraente que captura a essência do seu produto e as soluções que ele oferece ao seu cliente em relação aos problemas que você está tentando resolver.

            </p>
            <p>
              <h4>Conceito de alto nivel</h4>
              <p>Um conceito de alto nível em apenas uma frase, descreva seu produto, utilize termos que são amplamente conhecidos e bem estabelecidos, exemplo, “Dieta não é escravidão”, uma forma de dieta para quem não suporta fazer dietas.</p>

            <h4>Soluções</h4>

            Defina os três principais recursos que seu produto ou serviço oferece para resolver os problemas de seus clientes. Neste ponto, descreva sucintamente as melhores soluções do seu produto e aposte também em elaborar um MVP (produto mínimo viável), que consiste em um produto com o mínimo de recursos possível, mas que serve para conhecer a reação do mercado sobre a sua viabilidade.

            </p>

            <h4> Canais </h4>
            <p>
            Esta seção descreve a maneira como você alcançará seus clientes. Quais são seus “Pontos de contato” com um cliente? É importante entender como seus clientes terão ciência sobre sua solução para os problemas deles, como você entrega esta solução e como você se comunica antes e depois da compra com seus clientes. No estágio inicial tente não pensar em escala, mas concentre-se no aprendizado.

            </p>
            <p>
            <h4> Fluxos de receita </h4>
            Descreva as fontes de receita que você tem. É preciso determinar qual será o modelo de receita, como também definir valores para o produto/serviço. Um bom começo pode ser oferecer um único plano, com uma avaliação inicial gratuita, para atrair a atenção dos clientes em prospecção;

            </p>

            <h4> Estrutura de custo</h4>
            <p>
            Liste todos os custos do seu negócio. Não se esqueça dos custos de aquisição de clientes, custos de distribuição, taxas de processamento de pagamento, etc. Analise seu canvas e pense como cada seção pode gerar custos para o seu negócio.

            </p>

            <h4> Métricas de chave </h4>
            <p>
            Você precisa entender claramente a maneira como mede a saúde do seu negócio. Isto depende muito do modelo do negócio que você possui. Além disso, é uma boa prática escolher uma métrica de estrela guia para o seu negócio. Resumidamente, a métrica estrela guia apresenta três atributos:

            </p>
            <p>Mensura valor para o cliente;</p>
            <p>Representa uma estratégia do produto;</p>
            <p>É um indicador forte para renovação e crescimento da empresa/produto</p>


            <h4> Vantagem injusta ou competitiva </h4>
            <p>
            É aqui que você precisa concentrar sua energia para pensar no grande diferencial da sua startup, que a fará se destacar diante da concorrência e que irá trazer inovação para o mercado em que você está inserido. Este é o mais difícil de responder. A única vantagem competitiva real é aquilo que não pode ser copiado e não pode ser comprado
            Jason Cohen diz: Poderia ser informações internas, autoridade pessoal, comunidade, equipe dos sonhos, reputação, etc.
            </p>




            <p>O Lean Canvas está diretamente relacionado com a ideia de Lean Startup, uma filosofia que prega o uso enxuto de recursos e a máxima eficiência possível nesse tipo de negócio. São metodologias que o seu negócio pode adotar para ter melhores resultados e crescer de forma mais escalável. </p>

            <h3>A ideia tá ái, bora fazer!</h3>
          </Grid.Col>
        </Grid.Row>
      </Grid>
    </Tabs.Pane>
  </Tabs>
);

export default HowToCanvas;
