'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderToMarkup;

var _felaUtils = require('fela-utils');

var sheetMap = {
  fontFaces: _felaUtils.FONT_TYPE,
  statics: _felaUtils.STATIC_TYPE,
  keyframes: _felaUtils.KEYFRAME_TYPE,
  rules: _felaUtils.RULE_TYPE
};
function renderToMarkup(renderer) {
  var markup = '';

  for (var style in sheetMap) {
    if (renderer[style].length > 0) {
      markup += (0, _felaUtils.createStyleTagMarkup)(renderer[style], sheetMap[style]);
    }
  }

  for (var media in renderer.mediaRules) {
    var mediaCSS = renderer.mediaRules[media];

    if (mediaCSS.length > 0) {
      markup += (0, _felaUtils.createStyleTagMarkup)(mediaCSS, _felaUtils.RULE_TYPE, media);
    }
  }

  return markup;
}