'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _sheetMap;

exports.default = createDOMInterface;

var _felaUtils = require('fela-utils');

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var sheetMap = (_sheetMap = {}, _defineProperty(_sheetMap, _felaUtils.FONT_TYPE, 'fontFaces'), _defineProperty(_sheetMap, _felaUtils.STATIC_TYPE, 'statics'), _defineProperty(_sheetMap, _felaUtils.KEYFRAME_TYPE, 'keyframes'), _sheetMap);

function createDOMInterface(renderer) {
  renderer.styleNodes = (0, _felaUtils.reflushStyleNodes)();
  var baseNode = renderer.styleNodes[_felaUtils.RULE_TYPE];

  return function changeSubscription(change) {
    if (change.type === _felaUtils.CLEAR_TYPE) {
      for (var node in renderer.styleNodes) {
        renderer.styleNodes[node].textContent = '';
      }

      return;
    }

    var styleNode = (0, _felaUtils.getStyleNode)(renderer.styleNodes, baseNode, change.type, change.media);

    if (change.type === _felaUtils.RULE_TYPE) {
      // only use insertRule in production as browser devtools might have
      // weird behavior if used together with insertRule at runtime
      if (process.env.NODE_ENV !== 'production') {
        if (change.media) {
          styleNode.textContent = renderer.mediaRules[change.media];
        } else {
          styleNode.textContent = renderer.rules;
        }
      } else {
        try {
          styleNode.sheet.insertRule(change.selector + '{' + change.declaration + '}', styleNode.sheet.cssRules.length);
        } catch (error) {
          // TODO: maybe warn in dev?
        }
      }
    } else {
      styleNode.textContent = renderer[sheetMap[change.type]];
    }
  };
}